/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.EllipseIterator;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.RectangularShape;
import com.sun.javafx.geom.transform.BaseTransform;

public class Ellipse2D
extends RectangularShape {
    public float x;
    public float y;
    public float width;
    public float height;

    public Ellipse2D() {
    }

    public Ellipse2D(float x, float y, float w, float h) {
        this.setFrame(x, y, w, h);
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public boolean isEmpty() {
        return this.width <= 0.0f || this.height <= 0.0f;
    }

    @Override
    public void setFrame(float x, float y, float w, float h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
    }

    @Override
    public RectBounds getBounds() {
        return new RectBounds(this.x, this.y, this.x + this.width, this.y + this.height);
    }

    @Override
    public boolean contains(float x, float y) {
        float ellw = this.width;
        if (ellw <= 0.0f) {
            return false;
        }
        float normx = (x - this.x) / ellw - 0.5f;
        float ellh = this.height;
        if (ellh <= 0.0f) {
            return false;
        }
        float normy = (y - this.y) / ellh - 0.5f;
        return normx * normx + normy * normy < 0.25f;
    }

    @Override
    public boolean intersects(float x, float y, float w, float h) {
        if (w <= 0.0f || h <= 0.0f) {
            return false;
        }
        float ellw = this.width;
        if (ellw <= 0.0f) {
            return false;
        }
        float normx0 = (x - this.x) / ellw - 0.5f;
        float normx1 = normx0 + w / ellw;
        float ellh = this.height;
        if (ellh <= 0.0f) {
            return false;
        }
        float normy0 = (y - this.y) / ellh - 0.5f;
        float normy1 = normy0 + h / ellh;
        float nearx = normx0 > 0.0f ? normx0 : (normx1 < 0.0f ? normx1 : 0.0f);
        float neary = normy0 > 0.0f ? normy0 : (normy1 < 0.0f ? normy1 : 0.0f);
        return nearx * nearx + neary * neary < 0.25f;
    }

    @Override
    public boolean contains(float x, float y, float w, float h) {
        return this.contains(x, y) && this.contains(x + w, y) && this.contains(x, y + h) && this.contains(x + w, y + h);
    }

    @Override
    public PathIterator getPathIterator(BaseTransform tx) {
        return new EllipseIterator(this, tx);
    }

    @Override
    public Ellipse2D copy() {
        return new Ellipse2D(this.x, this.y, this.width, this.height);
    }

    public int hashCode() {
        int bits = Float.floatToIntBits(this.x);
        bits += Float.floatToIntBits(this.y) * 37;
        bits += Float.floatToIntBits(this.width) * 43;
        return bits += Float.floatToIntBits(this.height) * 47;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Ellipse2D) {
            Ellipse2D e2d = (Ellipse2D)obj;
            return this.x == e2d.x && this.y == e2d.y && this.width == e2d.width && this.height == e2d.height;
        }
        return false;
    }
}

